import { contractInterface } from '../../../../lib/contract_interface_v5'

export const createTxData = (functionName: string, params: any[]): string => {
  return contractInterface.encodeFunctionData(functionName, params)
}

export type SetIdentityParams = {
  destination: string
  identityInfo: {
    regions: number[]
    accreditationType: number
    lastAmlKycChangeTimestamp: number
    lastAccreditationChangeTimestamp: number
    amlKycPassed: boolean
  }
}

export const createTxDataForSetIdentity = (
  params: SetIdentityParams,
): string => {
  return createTxData('setIdentity', [params.destination, params.identityInfo])
}

export type SetTokenTypeRuleParams = {
  region: number
  accreditation: number
  tokenType: number
  requiresAmlKyc: boolean
  isActive: boolean
}

export const createTxDataForSetTokenTypeRule = (
  params: SetTokenTypeRuleParams,
): string => {
  return createTxData('setTokenTypeRule', [
    params.region,
    params.accreditation,
    params.tokenType,
    params.requiresAmlKyc,
    params.isActive,
  ])
}

export type SetTransferRuleParams = {
  tokenType: number
  recipientRegion: number
  recipientAccreditation: number
  transferRule: {
    lockDurationSeconds: number
    requiresAmlKyc: boolean
    isActive: boolean
  }
}

export const createTxDataForSetTransferRule = (
  params: SetTransferRuleParams,
): string => {
  return createTxData('setTransferRule', [
    params.tokenType,
    params.recipientRegion,
    params.recipientAccreditation,
    params.transferRule,
  ])
}

export type MintParams = {
  to: string
  value: number
}

export const createTxDataForMint = (params: MintParams): string => {
  return createTxData('mint', [params.to, params.value])
}

export type GrantRoleParams = {
  to: string
  role: number
}

export const createTxDataForGrantRole = (params: GrantRoleParams): string => {
  return createTxData('grantRole', [params.to, params.role])
}
